%% Figure 1 Plot
load('2_ModelRsquared')
% Data is loaded as different clinical groups with 6 by n matrices in 
% 1 by n cell. The six values for each n subject represents model R^2 on
%{CBF, Abeta, functional activity, glucose metabolism, grey matter density, and tau}

HC= cell2mat(HC)';
EMCI = cell2mat(EMCI)';
LMCI = cell2mat(LMCI)';
AD = cell2mat(AD)';

clinicalGroup = {'HC','EMCI', 'LMCI', 'AD'};
size = 0.4;
FigH = figure('Position', get(0, 'Screensize'));
F = getframe(FigH);
notBoxPlot(HC, 1, 'jitter',size);
hold;
notBoxPlot(EMCI, 2,'jitter',size);
notBoxPlot(LMCI, 3, 'jitter', size);
notBoxPlot(AD, 4, 'jitter', size);
set(gca,'xtick',[1:4],'xticklabel',clinicalGroup, "FontSize",16)
xlabel("Clinical group")
ylabel("R^2")
ax = gca;
ax.FontSize = 22;
ylim([0 1.1])
box on

%% 

   